//-------------//
// MENU SCRIPT //
//-------------//

// Updated: 03/01/08
// Created: 08/20/07

// Create the menu class

function Menu(x, y, w)
{
	if (this instanceof Menu == false) return new Menu();
	
	this.x = x; this.y = y; this.w = w;
	this.items = []; // the item array... "new", "options", "etc..."
	this.window = LoadWindowStyle('Window.rws');
	this.font = font;
	this.onCancel = function(){};
	this.cancelable = true;
	this.openHeight = 0;
	this.BG = GrabImage(0, 0, SW, SH);
	this.preRender = undefined;
	this.postRender = undefined;
	this.CI = 0;
}

// Create function that appends a new choice

Menu.prototype.appendChoice = function(name, call, colorup, colordown)
{
	// Create a temporary object:
	var tempItem = {};
	tempItem.name = name;
	tempItem.call = call;
	tempItem.colorup = colorup;
	tempItem.colordown = colordown;
	// And add the it to the array:
	this.items.push(tempItem);
}

// Create function that draws the menu

Menu.prototype.draw = function()
{
	// Create temporary variables:
	SetFrameRate(GameSpeed);
	if(IsMapEngineRunning()) { UpdateMapEngine(); RenderMap(); }
	this.BG = GrabImage(0, 0, SW, SH);
	this.arrow = new MArrow('MArrow.png', this.x, this.y+4);
	var active = true;
	var height = 20;
	// set the height
	var h = this.items.length*height+6;
	
	// Open the menu
	this.open(500);
	
	// Start the loop:
	ClearKeyQueue();
	while(active)
	{
		with(this) {
			if(preRender != undefined) preRender();
			else if(IsMapEngineRunning()) { UpdateMapEngine(); RenderMap(); }
			window.drawWindow(x,y,w,h);
			for (var i = 0; i < items.length; ++i) {
				if (CI == i && arrow.y == arrow.newY) font.setColorMask(items[i].colordown);
				else font.setColorMask(items[i].colorup);
				font.drawText(x+16,y+i*height,items[i].name);
			}
			arrow.blit();
		
			FlipScreen();
		
			// Handle keyboard input:
			while(AreKeysLeft()) {
				switch(GetKey()) {
					case KEY_UP:
						if (CI > 0) {CI--; arrow.newY -= height;}
					break;
					case KEY_DOWN:
						if (CI < items.length-1) {CI++; arrow.newY += height;}
					break;
					//case KEY_ENTER:
					case KEY_CTRL:
					case KEY_SPACE:
					case KEY_ENTER:
						close(500);
						if(this.postRender != undefined) this.postRender();	
						items[CI].call();
						return;
					break;
					case KEY_SHIFT:
					case KEY_ESCAPE:
						if(cancelable) {
							close(500);
							if(this.postRender != undefined) this.postRender();
							onCancel();
							active = false; // turns menu off
						}
					break;
				}
			}
		}
	}
}

// Create function that opens the menu:
Menu.prototype.open = function(ms)
{
	var time = GetTime();
	with(this) {
		var h = items.length*arrow.img.height;
		while (GetTime() - time < ms) {
			var i = (GetTime() - time) * h / ms;
			if(preRender != undefined) preRender();
			else BG.blit(0,0);
			window.drawWindow(x,y+h/2-i/2,w,i);
			FlipScreen();
		}
	}
}

// Create function that closes the menu
Menu.prototype.close = function(ms)
{
	var time = GetTime();
	with(this) {
		var h = items.length*arrow.img.height;
		while (GetTime() - time < ms) {
			var i = h - (GetTime() - time) * h / ms;
			if(preRender != undefined) preRender();
			else BG.blit(0,0);
			window.drawWindow(x,y+h/2-i/2,w,i);
			FlipScreen();
		}
	}
}

// Create an Arrow Object
function MArrow(img,x,y)
{
	this.img = LoadImage(img);
	this.x = x;
	this.y = y;
	this.newX = x;
	this.newY = y;
}

MArrow.prototype.blit = function()
{
	with(this) {
		var nx = newX - x;
		var ny = newY - y;
		update();
		Line(x+img.width/2,y+img.height/2,x+img.width/2+nx,y+img.height/2+ny,Blue);
		Line(x+img.width/2+1,y+img.height/2,x+img.width/2+nx+1,y+img.height/2+ny,Blue);
		img.blit(x, y+2);
	}
}

MArrow.prototype.update = function()
{
	with(this) {
		if (newX > x) x+=4;
		if (newY > y) y+=4;
		if (newX < x) x-=4;
		if (newY < y) y-=4;
	}
}

function ClearKeyQueue()
{
	while(AreKeysLeft()) {GetKey();}
}